var showUptime = true;
var recordKey = 0;

function setup() {
	if (window.widget)
	{
	    widget.onshow = onshow;
	    widget.onhide = onhide;
	
		readPrefs();
	}
	createGenericButton(document.getElementById('done'), 'Back', hidePrefs);
	onshow();
}

function toggleDisplay() {
	showUptime = !showUptime;
	onshow();
}

function goToUrl(url)
{
	if (window.widget)
	{
		widget.openURL(url);
	}
}


// defaults -currentHost read com.jokkedk.showoff UptimeRecord
function onshow() {
	readPrefs();
	if(showUptime) {
		document.getElementById("uptime").innerText = fetchUptime();
		document.getElementById("info").innerText = "uptime";
	} else {
		document.getElementById("uptime").innerText = fetchRecord();
		document.getElementById("info").innerText = "record";
	}
}

function onhide() {
	var currentMinutes = getMinutes(fetchUptime().split(","));
	if(currentMinutes > recordKey)
		widget.setPreferenceForKey(currentMinutes, "record");
}

function fetchUptime() {
	//debug value;
	//outString = "18:44  up 1 day, 21 mins, 8 users, load averages: 1.61 1.76 1.67";
	outString = widget.system("/usr/bin/uptime", null).outputString;
	var upString = outString.substring(0,outString.indexOf("load")-2);
	upString = upString.substring(upString.indexOf("up")+3,upString.lastIndexOf(","));
	return upString;
}

function fetchRecord() {
	var currentUp = 0;
	var current = fetchUptime().split(",");
	
	currentUp = getMinutes(current);
	
	// is old record still valid?
	if(recordKey != 0 && recordKey > currentUp) {
		var tmp = 0;
		tmp = recordKey % 1440;
		var days = (recordKey-(recordKey % 1440))/1440; 
		var hours = (tmp-(tmp % 60))/60; 
		var minute = tmp % 60;
		var recordString = "";
		
		if(days > 0) {
			if(days == 1)
				recordString += days+" day, ";
			else
				recordString += days+" days, ";
		}
		if(hours > 0) {
			if(hours < 10)
				recordString += "0";
			recordString += hours+":";
		}
		if(minute < 10)
			recordString += "0";
		recordString += minute;
		if(hours == 0)
			recordString += " mins";
		
		return recordString;
	}
	// else new record
	else {
		return current;
	}
}

function getMinutes(string) {
	var currentUp = 0;
	for(i=string.length-1;i>=0;i--) {
		// minutes and hours
		if(i==string.length-1) {
			var timePart = string[i].split(":");
			// we have both hours and minutes
			if(timePart.length > 1) {
				currentUp = Number(timePart[1]);
				currentUp += Number(timePart[0]*60);
			}
			// either less than one hour or a whole amount of hours
			else {
				timePart = string[i].split(" ");
				if(timePart[1]=="hrs" || timePart[1]=="hours" || timePart[1]=="hour")
					currentUp = Number(string[i]*60);
				else if(timePart[1]=="min" || timePart[1]=="mins")
					currentUp = Number(string[i]);
			}
		}
		// we have days
		else if(i==string.length-2) {
			timePart = string[i].split(" ");
			currentUp += Number(timePart[0]*24*60);
		}
		// reaching weeks
		else if(i==string.length-3) {
			timePart = string[i].split(" ");
			currentUp += Number(timePart[0]*7*24*60);
		}
	}
	return currentUp;
}

function readPrefs() {
	recordKey = widget.preferenceForKey("record");
	if (isNaN(recordKey))
	{
		recordKey = 0;
	}
}

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");
       
	front.style.display="none";
	back.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);  
}

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");
      
	back.style.display="none";
	front.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!flipShown)
	{
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
 
		var starttime = (new Date).getTime() - 13;
 
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}
function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}

		var starttime = (new Date).getTime() - 13;

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}
function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
   

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}
function limit_3 (a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}